import Layout from "@/app/components/layout";
import BookChaptersList from "./BookChapterList";
import { getBookIdChapters } from '@/lib/services/chapterService';
import { getBookById } from "@/lib/services/bookService";

export const dynamic = "force-dynamic"; // ensures fresh DB read

export default async function BooksListIdByChaptersPage({ params }) {
    const bookId = params.id; // ✅ params comes from server component props

    const chapters = await getBookIdChapters(bookId);
    const books = await getBookById(bookId);

    return (
        <Layout>
            <BookChaptersList
                initialChapters={chapters}
                books={books}
            />
        </Layout>
    );
}
